'*******************************************************************************
'  EERAM SETUP                         'SVN Rev.227 09.01.2011
'*******************************************************************************
'
'  Copyright bascom-forum.de (C) [2009]  [DON]
'  -> http://bascom-forum.de/index.php?topic=1781.new;topicseen#new
'  Software based on Code by Ben Zijlstra and Viktor Varga
'  Weiterentwickelt von
'    Huetti,
'    Michael
'    boeserkorn
'    mr_energy
'    HansHans
'    six1, Michael Kcher
'    dabuze                            datetime
'    framuel
'    tfv
'
'   http://creativecommons.org/licenses/by-sa/3.0/de/
'
'   Sie drfen:
'
'     * das Werk bzw. den Inhalt vervielfltigen, verbreiten und ffentlich zugnglich machen
'
'     * Abwandlungen und Bearbeitungen des Werkes bzw. Inhaltes anfertigen
'
'   Zu Den Folgenden Bedingungen:
'
'     * Namensnennung.
'       Sie mssen den Namen des Autors/Rechteinhabers in der von ihm festgelegten Weise nennen.
'
'     * Keine kommerzielle Nutzung.
'       Dieses Werk darf nicht fr kommerzielle Zwecke verwendet werden.
'
'     * Weitergabe unter gleichen Bedingungen.
'       Wenn Sie das lizenzierte Werk bzw. den lizenzierten Inhalt bearbeiten
'       oder in anderer Weise erkennbar als Grundlage fr eigenes Schaffen verwenden,
'       drfen Sie die daraufhin neu entstandenen Werke bzw. Inhalte nur
'       unter Verwendung von Lizenzbedingungen weitergeben, die mit denen
'       dieses Lizenzvertrages identisch oder vergleichbar sind.
'
'   Wobei gilt:
'
'     * Verzichtserklrung
'       Jede der vorgenannten Bedingungen kann aufgehoben werden, sofern Sie
'       die ausdrckliche Einwilligung des Rechteinhabers dazu erhalten.
'
'     * Sonstige Rechte
'       Die Lizenz hat keinerlei Einfluss auf die folgenden Rechte:
'          - Die gesetzlichen Schranken des Urheberrechts und sonstigen
'            Befugnisse zur privaten Nutzung
'          - Das Urheberpersnlichkeitsrecht des Rechteinhabers
'          - Rechte anderer Personen, entweder am Lizenzgegenstand selber oder
'            bezglich seiner Verwendung, zum Beispiel Persnlichkeitsrechte abgebildeter Personen.
'
'  Hinweis
'
'      Im Falle einer Verbreitung mssen Sie anderen alle Lizenzbedingungen
'      mitteilen, die fr dieses Werk gelten. Am einfachsten ist es,
'      einen Link auf http://creativecommons.org/licenses/by-sa/3.0/de/ einzubinden.
'

'*******************************************************************************
$nocompile

'*******************************************************************************
'  Update der Freesol-Werte
'*******************************************************************************
Sub Fs_freesol_update
   Local Svor As Integer
   Local Ltemp As Long
   Local Ltemp2 As Long
   Local Ltemp3 As Long
   Local Offs As Integer
   Local Offsmin As Integer
   Local Offsmin2 As Integer
   Local Offsmin3 As Integer
   Local Pzt As Long
   Local I As Integer
   Local J As Integer
   Local L As Long
   Local L2 As Long
   Local W As Word
   Local S2 As String * 10
   Local S3 As String * 10
   Local S4 As String * 10
   Local S As Single
   Local Ind_be As Integer
   Local Temp As Integer


   S2 = Date(netio_time)
   S4 = Time(netio_time)
   S3 = Fusing(fs_bezug , "##.###")
   Print "Heartbeat: " ; S2 ; " " ; S4 ; " " ; S3 ; " " ; Str(my_b_ipaddr(1)) ; "." ; Str(my_b_ipaddr(2)) ; "." ; Str(my_b_ipaddr(3)) ; "." ; Str(my_b_ipaddr(4))       '
   S3 = Fusing(fs_bezug , "##.###")
   S4 = Fusing(fs_einspeis , "##.###")
   Print "    Start:  " ; Fs_startzeit_ntp ; " S0: " ; Fs_pulszahl ; " SML 1: " ; S3 ; " SML 2: " ; S4
#if Debug_freesol
   S2 = Date(netio_time)
   L = Sysday(netio_time)
   Print "fs_freesol_update: Date(netio_time): " ; S2 ; " " ; L
     #if Fs_debugvar = 1
      If Fs_ersteraufruf = 0 Then
         Fs_ersteraufruf = 1                                ' Nur einmal ausfhren
         Print "Eprom-Werte von Freesol"
         Fs_eeram_lesen
      End If
    #endif
    #if Fs_debugvar = 2
       If Fs_ersteraufruf = 0 Then
         Fs_ersteraufruf = 1
         Fs_eeram_loeschen
         Print "Eprom-Werte von Freesol geloescht"
         Fs_eeram_lesen
       End If
    #endif
     #if Fs_debugvar = 3
       If Fs_ersteraufruf = 0 Then
         Fs_ersteraufruf = 1
         Fs_eeram_dummy
         Print "Eprom-Werte von Freesol mit Dummy belegt"
         Fs_eeram_lesen
       End If
    #endif
#endif
   If Fs_alarmmailflag2 = 1 Then
    If Fs_alarmmailflag = 0 Then
      If Fs_mailstatus = 0 Then
          Print "Alarmmailversand"
          Fs_mailstatus = 2
          Smtp_mail_versand_in = 1
          Fs_alarmmailflag2 = 0
      End If
    End If
   Else
    If Fs_alarmmailflag = 1 Then
      Fs_alarmmailflag2 = 1
    End If
   End If

    L = Sysday(netio_time)
    If Ntp_valid = 1 Then                                   'Verbessert: Nur bei gltiger Zeit; alt: L > 4300 Then (Datum im Jahr 2011)
      If Fs_ersteraufruf = 0 Then
         Fs_ersteraufruf = 1
         Fs_eeram_lesen
      End If
      Fs_tagesmax = 0
      For J = 99 To 0 Step -1                               '9
         L = Fs_speicherdatum_tage - J
         W = L
         S2 = Date(w)
         L2 = L Mod 100                                     ' 5-8-12 Bug korrigiert (1)
         I = L2
         If I = 0 Then                                      ' 5-8-12 Bug korrigiert (1)
            I = 100
         End If
         If Fs_tageswerte(i) > 0 Then
            Fs_tagesmax = J + 1
            J = 0
         End If
      Next J

      Offs = _hour + 1
      Pzt = Fs_pulszahl
      If Offs > 0 Then
         If Offs < 23 Then                                  ' Bei Stunde 24 wird das nicht mehr gemacht!
               Svor = Offs - 1
               Fs_stundenstart(offs) = Pzt
               If Svor = 0 Then
                  Ltemp = Fs_stundenstart(offs)
               Else
                  Ltemp = Fs_stundenstart(svor )
               End If
               Ltemp2 = Fs_stundenstart(offs )
               Fs_stundenwerte(offs) = Ltemp2 - Ltemp
         End If
      End If
      If Offs > 4 Then                                      ' 5min S0 Werte eintragen
         If Offs < 23 Then
            Ltemp = Fs_minlast
            Ltemp2 = Pzt
            Offsmin = _min
            Offsmin2 = Offsmin / 5
            Offsmin2 = Offsmin2 * 5
            #if Debug_freesol
             Print Offsmin2 ; "  " ; Offsmin ; "  " ; Ltemp2 ; "  " ; Ltemp
            #endif
            Ltemp3 = Ltemp2 - Fs_minlast_min
            Fs_akt_leist_min = Ltemp3 / Fs_pulsfaktor
            Fs_akt_leist_min = Fs_akt_leist_min * 60
            Fs_minlast_min = Ltemp2
            If Offsmin2 = Offsmin Then                      ' Alle 5 min ausgefhrt
               Offsmin2 = Offsmin / 5
               Fs_min_j = Offsmin2
               Offsmin3 = Offs - 5                          'Offsmin3=0 fr 4 Uhr
               Fs_min_i = Offsmin3
               Offsmin3 = Offsmin3 * 12
               Offsmin3 = Offsmin3 + Offsmin2
               Fs_minlast = Ltemp2
               Ltemp2 = Ltemp2 - Ltemp
               If Offsmin3 > 0 Then
                  Fs_minw(offsmin3) = Ltemp2                ' Routine speichert ersten Wert um 4.00 Uhr fr die 5 min davor  ;Speicherindex startet bei 0, sinnvolle Werte aber erst ab 1
                  Ee_fs_minw(offsmin3) = Fs_minw(offsmin3)
               End If
               Fs_akt_leist = Ltemp2 / Fs_pulsfaktor
               Fs_akt_leist = Fs_akt_leist * 12
               S = Fs_akt_leist * 1000
               J = S
               If J > Fs_schaltschwelle Then                'akt. Leistung liegt ber Schaltschwelle
                     Fs_schaltdauertemp = Fs_schaltdauer    ' Falls Signal schon an war, bleibt es wieder Schaltdauer an. Falls noch nicht an, wird es angeschalten. Falls Schaltdauer=0, bleibt es damit aus, weil spter Schaltdauer abgefragt wird
                     Fs_schaltsignal = 1                    ' Ausgang einschalten
               Else
                  If Fs_schaltdauertemp > 0 Then
                     Fs_schaltdauertemp = Fs_schaltdauertemp - 1
                  End If
                  If Fs_schaltdauertemp = 0 Then
                     Fs_schaltsignal = 0                    'Ausgang ausschalten
                  End If

               End If
                Fs_minpos = Offsmin3
            End If
         End If
      End If

      ' 5min SML Werte eintragen
      Offsmin = _min
      Offsmin2 = Offsmin / 5
      Offsmin2 = Offsmin2 * 5
      #if Debug_freesol
       Print Offsmin2 ; "  " ; Offsmin ; "  " ; Ltemp2 ; "  " ; Ltemp
      #endif
      If Offsmin2 = Offsmin Then                            ' Alle 5 min ausgefhrt

         Ind_be = Offsmin / 5                               'Speicherindex ind_be berechnen, startet bei 1
         Ind_be = Ind_be
         Temp = _hour
         Temp = Temp * 12
         Ind_be = Ind_be + Temp
         Ind_be = Ind_be

         If Ind_be = 0 Then                                 'Tagesstand um 0.00 Uhr abspeichern
            Fs_eeram_sml_akt_tag_speich
            Fs_sml_tagesw_gespeichert = 1
         Elseif Fs_sml_tagesw_gespeichert = 0 Then          'ansonsten abspeichern, falls noch nicht abgespeichert ist
            Fs_sml_tagesw_gespeichert = 1
            Fs_eeram_sml_akt_tag_speich
         End If

        ' 5min-Werte Bezug, Einspeis bestimmen und abspeichern (in Wh, Differenz zum Vorwert)
        If Ind_be > 0 Then
         If Fs_bezug_l_alt > 0 Then
            Temp = Fs_bezug_l - Fs_bezug_l_alt              'Speicherindex ind_be berechnen, startet bei 1
            Fs_min_bezug(ind_be) = Temp
            Ee_fs_min_bezug(ind_be) = Temp

            Temp = Fs_einspeis_l - Fs_einspeis_l_alt
            Fs_min_einspeis(ind_be) = Temp
            Ee_fs_min_einspeis(ind_be) = Temp
         End If
        End If

        Fs_bezug_l_alt = Fs_bezug_l
        Fs_einspeis_l_alt = Fs_einspeis_l
        Fs_minpos_bez = Ind_be
      End If



      Offsmin = _min
      Offsmin2 = Offsmin / 5
      Offsmin2 = Offsmin2 * 5

      If Offsmin2 = Offsmin Then
         If Fs_maildebugflag = 1 Then
                  If Ntp_valid = 1 Then
                    Fs_mail_datum = Date$
                  Else
                    Fs_mail_datum = "01.01.11"
                  End If
                  Fs_mail_energie = 88888
                  Fs_mail_energienorm = Fs_mail_energie / Fs_anlagenleistung
                  Smtp_mail_versand_in = 1
                  Print "Testmail senden"
                  #if System_message > 0
                     Print "Mail_versand_in = " ; Smtp_mail_versand_in ; " Minuten "
                  #endif
          End If
      End If

      If Offs = 24 Then                                     '24 Vorschub um 23.56 Uhr
         If _min = 56 Then                                  '56
           ' Aktuellen Tag schreiben
            Fs_eeram_akt_tag_speich
         End If

      End If

      If Offs = 2 Then                                      '1 Booten nachts um 01.17 (nicht zwischen 0 und ein Uhr, sonst Probleme bei Zeitumstellungm, da zwei Boots)
         If _min = 17 Then                                  '30
           ' Booten ber Watchdog
            Wait 10
         End If
       End If

   Else                                                     ' auch ohne erfolgreiche Zeitsynchrionisierung nach 30 min rebooten
       If _min > 30 Then                                    '30
           ' Booten ber Watchdog
            Wait 10
       End If
   End If
End Sub


'*******************************************************************************
'  Freesol-Werte aus Eeram lesen
'*******************************************************************************
Sub Fs_eeram_lesen
   Local I As Integer
   Local J As Integer
   Local K As Integer
   Local K1 As Integer
   Local L As Long
   Local L1 As Long
   Local L2 As Long
   Local D As Long


   Fs_anlagenleistung = Ee_fs_anlagenleistung

   If Fs_anlagenleistung = 0 Then
      Print "Fehler: Fs-anlagenleistung = 0"
   End If

   Fs_speicherdatum_tage = Ee_fs_speicherdatum_tage

   ' Hier wird ein mglicher fehler aus ungltigen (negativen) Fs_speicherdatum_tage abgefangen
   If Fs_speicherdatum_tage < 0 Then
      Fs_speicherdatum_tage = 0
      Ee_fs_speicherdatum_tage = Fs_speicherdatum_tage
   End If

   'Prfen, ob ungltige Werte im Eram vorliegen, und diese ggf berschreiben
   'Diese Routine ist ungetestet
   L = Sysday(netio_time)                                   'war Sysday(netio_time)
   L = L - 1

   If L > Fs_speicherdatum_tage Then                        ' Hier werden Vortage im Ringspeicher auf 0 gesetzt, falls an diesen kein Wert abgespeichert wurde
      L2 = L - Fs_speicherdatum_tage
      If L2 > 100 Then
         L2 = L - 100
      Else
         L2 = Fs_speicherdatum_tage + 1
      End If
      For L1 = L2 To L
          D = L1 Mod 100
          I = D                                             ' 5-8-12 Bug korrigiert (2)
          If I = 0 Then                                     ' 5-8-12 Bug korrigiert (2)
            I = 100
          End If
          Ee_fs_tageswerte(i) = 0
          Fs_tageswerte(i) = 0
      Next L1
      Fs_speicherdatum_tage = L
      Ee_fs_speicherdatum_tage = Fs_speicherdatum_tage
   End If

   'Werte Einlesen
   For I = 1 To 100
      Fs_tageswerte(i) = Ee_fs_tageswerte(i)
   Next I

#if Debug_freesol
   For I = 1 To 10
      Print "Tageswerte: " ; Str(i) ; "  " ; Str(fs_tageswerte(i))
   Next I
   Print "Speicherdatum Tage: " ; Str(fs_speicherdatum_tage )
#endif
   Fs_speicherdatum_monate = Ee_fs_speicherdatum_monate
   Fs_monatswerte = Ee_fs_monatswerte
#if Debug_freesol
   Print "Monatswerte Vormonat: " ; Str(fs_monatswerte) ; "  Speicherdatum: " ; Str(fs_speicherdatum_monate )
#endif
   Fs_speicherdat_lfdmon = Ee_fs_speicherdat_lfdmon
   Fs_lfdmonwerte = Ee_fs_lfdmonwerte
#if Debug_freesol
   Print "Monatswerte aktuell: " ; Str(fs_lfdmonwerte) ; "  Speicherdatum: " ; Str(fs_speicherdat_lfdmon )
#endif

   Fs_pulszahlges = Ee_fs_pulszahlges
   Fs_pulsfaktor = Ee_fs_pulsfaktor
   Fs_lcd = Ee_fs_lcd
   Fs_maildebugflag = Ee_fs_maildebugflag

   Fs_schaltschwelle = Ee_fs_schaltschwelle
   Fs_alarmmailtext = Ee_fs_alarmmailtext
   Fs_schaltdauer = Ee_fs_schaltdauer

   Fs_speicherdatum_minuten = Ee_fs_speicherdatum_minuten

   L = Sysday(netio_time)                                   'war Sysday(netio_time)
   If Fs_speicherdatum_minuten = L Then                     'Minutenwerte wurden heute schon mal gespeichert, wieder reinholen
      For I = 1 To 216
         Fs_minw(i) = Ee_fs_minw(i)
      Next I
      L1 = 0                                                'Stundenwerte rekonstruieren
      For I = 1 To 24
         Fs_stundenstart(i) = 0
         Fs_stundenwerte(i) = 0
      Next
      K1 = _hour
      K1 = K1 + 1
      If K1 > 4 Then
         For I = 5 To K1
            L = 0
            For J = 1 To 12
              K = I - 5
              K = K * 12
              K = K + J
              L = L + Fs_minw(k)
            Next J
            Fs_stundenstart(i) = L1 + L
            Fs_stundenwerte(i) = L
            L1 = L1 + L
         Next
         Fs_pulszahl = Fs_pulszahl + Fs_stundenstart(k1)
         Fs_minlast = Fs_stundenstart(k1)
      End If
   Else                                                     'Minutenwerte auch im Eprom lschen
      For I = 1 To 216
         Fs_minw(i) = 0
         Ee_fs_minw(i) = 0
      Next I
      Fs_speicherdatum_minuten = L
      Ee_fs_speicherdatum_minuten = Fs_speicherdatum_minuten
   End If

   'SML Werte laden
   Fs_bezug_speichdat_t = Ee_fs_bezug_speichdat_t
   Fs_einspeis_speichdat_t = Ee_fs_einspeis_speichdat_t

   For I = 1 To 30
      'Bezug laden
      Fs_bezug_tagesstand(i) = Ee_fs_bezug_tagesstand(i)

      'Einspeisung speichern
      Fs_einspeis_tagesstand(i) = Ee_fs_einspeis_tagesstand(i)
   Next I

   ' SML Minutenwerte laden
      For I = 1 To 288
         Fs_min_bezug(i) = 0
         Fs_min_einspeis(i) = 0
      Next I
   If _hour = 1 Then
       D = Fs_bezug_speichdat_t Mod 30                      ' 5-8-12 Bug korrigiert (3)
       I = D
       If I = 0 Then                                        ' 5-8-12 Bug korrigiert (3)
          I = 30
       End If
       Fs_bezug_l_alt = Fs_bezug_tagesstand(i)
       Fs_einspeis_l_alt = Fs_einspeis_tagesstand(i)        ' Startzeitpunkt nachts beim Reboot (Zeit 1.17), damit liegen wohl gltige Vortageswerte vor
       For I = 1 To 15                                      ' Wert 16 gehrt zu 1.15
         Fs_min_bezug(i) = Ee_fs_min_bezug(i)
         Fs_min_einspeis(i) = Ee_fs_min_einspeis(i)
         Fs_bezug_l_alt = Fs_bezug_l_alt + Fs_min_bezug(i)
         Fs_einspeis_l_alt = Fs_einspeis_l_alt + Fs_min_einspeis(i)
       Next I
       Fs_minpos_bez = 15
   End If

      ' Vortageswerte laden
   Fs_speichdat_vt_t = Ee_fs_speichdat_vt_t

   For J = 1 To 216
      Fs_minw_vt(j) = Ee_fs_minw_vt(j)
   Next J

   For J = 1 To 288
      Fs_min_bezug_vt(j) = Ee_fs_min_bezug_vt(j)
      Fs_min_einspeis_vt(j) = Ee_fs_min_einspeis_vt(j)
   Next J

   Fs_ev_url = Ee_fs_ev_url

End Sub


'*******************************************************************************
'  Freesol-Werte am aktuellen Tag ins Eram speichern
'*******************************************************************************
Sub Fs_eeram_akt_tag_speich
   Local I As Integer
   Local J As Integer
   Local K As Integer
   Local L As Integer
   Local D As Long
   Local D2 As Long
   Local Tag As Long
   Local Wsysday As Word
   Local S As String * 9

   Reset Watchdog
   #if System_message > 0
      Print "Routine Eeram aktuellen Tag speichern"
   #endif

   '( Ungetestet. Wird jetzt beim Einlesen gemacht
   ' Prfen, ob letztes Speicherdatum lter als Vortag
   D = Sysday(netio_time)
   D = D - 1
   If D > Fs_speicherdatum_tage Then
      D2 = Fs_speicherdatum_tage + 1
      For Tag = D2 To D
       L = Tag
       Fs_tageswerte(l) = 0
       Ee_fs_tageswerte(l) = 0
      Next
   End If
')

   ' Den Wert des heutigen Tages am Abend speichern
   Fs_speicherdatum_tage = Sysday(netio_time)               'war Sysday(netio_time)
   Ee_fs_speicherdatum_tage = Fs_speicherdatum_tage
   D = Fs_speicherdatum_tage Mod 100                        ' 5-8-12 Bug korrigiert (4)
   I = D
   If I = 0 Then                                            ' 5-8-12 Bug korrigiert (4)
      I = 100
   End If

   D = Fs_pulszahl - Fs_stundenstart(1)
   D2 = D / 10
   D2 = D2 * 10
   D2 = D - D2
   D = D / 10
   If D2 > 4 Then
      D = D + 1
   End If
   D = D * 1000
   D = D / Fs_pulsfaktor
   Fs_tageswerte(i) = D
   Ee_fs_tageswerte(i) = Fs_tageswerte(i)


   ' Zhlerstand speichern
   Fs_pulszahlges = Fs_pulszahlges + Fs_pulszahl
   Ee_fs_pulszahlges = Fs_pulszahlges

   ' Vortageswerte speichern
   Fs_speichdat_vt_t = Fs_speicherdatum_tage
   Ee_fs_speichdat_vt_t = Fs_speichdat_vt_t


   For J = 1 To 216
      Ee_fs_minw_vt(j) = Fs_minw(j)
   Next J

   Reset Watchdog

   For J = 1 To 288
      Ee_fs_min_bezug_vt(j) = Fs_min_bezug(j)
   Next J

   Reset Watchdog

   For J = 1 To 288
      Ee_fs_min_einspeis_vt(j) = Fs_min_einspeis(j)
   Next J


   ' Werte des aktuellen Tages lschen
   For J = 1 To 24
      Fs_stundenwerte(j) = 0
      Fs_stundenstart(j) = 0
   Next J

   For J = 1 To 216
      Fs_minw_vt(j) = Fs_minw(j)                            '16.5.12 eingefgt
      Fs_minw(j) = 0
   Next J

   Reset Watchdog

   For J = 1 To 288
      Fs_min_bezug_vt(j) = Fs_min_bezug(j)                  '16.5.12 eingefgt
      Fs_min_einspeis_vt(j) = Fs_min_einspeis(j)            '16.5.12 eingefgt
   Next J

   Reset Watchdog

    For J = 1 To 288
      Fs_min_bezug(j) = 0                                   '5.6.12 eingefgt
      Fs_min_einspeis(j) = 0                                '5.6.12 eingefgt
   Next J

   Reset Watchdog

   ' Mail lostreten
   Fs_mail_datum = Date$
   Fs_mail_energie = Fs_tageswerte(i) * 10
   Fs_mail_energienorm = Fs_mail_energie / Fs_anlagenleistung

   If Fs_mailstatus = 0 Then
      Fs_mailstatus = 1
      Smtp_mail_versand_in = 1
   End If

   #if System_message > 0
      Print "Mail_versand_in = " ; Smtp_mail_versand_in ; " Minuten "
   #endif


   ' laufenden Monat speichern
   Fs_lfdmonwerte = 0
   For L = 1 To _day
      K = 101 - L
      K = K + I                                             ' Achtung, I wird von oben bernommen! ' 5-8-12 Bug korrigiert (5)
      K = K Mod 100
      If K = 0 Then                                         ' 5-8-12 Bug korrigiert (5)
         K = 100
      End If
      Fs_lfdmonwerte = Fs_lfdmonwerte + Fs_tageswerte(k)
   Next J
   Fs_lfdmonwerte = Fs_lfdmonwerte * 10
   Fs_speicherdat_lfdmon = Sysday(netio_time)               'war sysday
   Ee_fs_speicherdat_lfdmon = Fs_speicherdat_lfdmon
   Ee_fs_lfdmonwerte = Fs_lfdmonwerte


    ' Feststellen ob Monatserster
   Tag = Sysday(netio_time)                                 'war Sysday(netio_time)
   Wsysday = Tag
   Wsysday = Wsysday + 1
   S = Date(wsysday)
   S = Left(s , 2)
   Tag = Val(s)

   If Tag = 1 Then
       ' Falls erster Tag im Monat, dann die zuletzt abgespeicherten Werte des aktuellen Monats als Monatswerte speichern
       Fs_speicherdatum_monate = Fs_speicherdat_lfdmon
       Ee_fs_speicherdatum_monate = Fs_speicherdatum_monate
       Fs_monatswerte = Fs_lfdmonwerte
       Ee_fs_monatswerte = Fs_monatswerte
   End If

   Reset Watchdog

   #if System_message > 0
      Print "Routine Eeram aktuellen Tag speichern beendet"
   #endif


End Sub


'*******************************************************************************
'  SML-Werte am Beginn des aktuellen Tags ins Eram speichern
'*******************************************************************************
Sub Fs_eeram_sml_akt_tag_speich
   Local I As Integer
   Local J As Integer
   Local K As Integer
   Local L As Integer
   Local D As Long
   Local D2 As Long
   Local Tag As Long
   Local Wsysday As Word
   Local S As String * 9
   Local Sing As Single

   #if System_message > 0
      Print "Routine Eeram SML aktuellen Tag morgens speichern"
   #endif

    ' Den SML-Zhlerstand des heutigen Tages am Morgen speichern
   Fs_bezug_speichdat_t = Sysday(netio_time)                'war Sysday(netio_time)
   Fs_einspeis_speichdat_t = Sysday(netio_time)             'war Sysday(netio_time)
   Ee_fs_bezug_speichdat_t = Fs_bezug_speichdat_t
   Ee_fs_einspeis_speichdat_t = Fs_einspeis_speichdat_t

   D = Fs_bezug_speichdat_t Mod 30                          ' 5-8-12 Bug korrigiert (6)
   I = D
   If I = 0 Then                                            ' 5-8-12 Bug korrigiert (6)
      I = 30
   End If


   'Bezug speichern
   Fs_bezug_tagesstand(i) = Fs_bezug_l
   Fs_bezug_tagesstart = Fs_bezug_l
   Ee_fs_bezug_tagesstand(i) = Fs_bezug_tagesstand(i)

   'Einspeisung speichern
   Fs_einspeis_tagesstand(i) = Fs_einspeis_l
   Fs_einspeis_tagesstart = Fs_einspeis_l
   Ee_fs_einspeis_tagesstand(i) = Fs_einspeis_tagesstand(i)
End Sub



'*******************************************************************************
'  Freesol-Werte im Eram lschen
'*******************************************************************************
Sub Fs_eeram_loeschen
Local I As Integer
Local Wsysday As Word
Local S As String * 9
Local J As Integer
   Wsysday = Sysday(netio_time)                             'war sysday
   Fs_speicherdatum_tage = 1000
   Fs_speicherdatum_tage = Fs_speicherdatum_tage - 1
   For I = 1 To 100
      Fs_tageswerte(i) = 0
   Next I
   Wsysday = Sysday(netio_time)                             'war sysday
   S = Date(wsysday)
   S = Left(s , 2)
   J = Val(s)
   Fs_speicherdatum_monate = Wsysday - J
   Fs_monatswerte = 0
   Fs_speicherdat_lfdmon = Sysday(netio_time)
   Fs_speicherdat_lfdmon = Fs_speicherdat_lfdmon - 1
   Fs_lfdmonwerte = 0

   Ee_fs_speicherdatum_tage = Fs_speicherdatum_tage
   #if Debug_freesol
   Print "Speicherdatum Tage geschrieben: " ; Fs_speicherdatum_tage
   #endif
   For I = 1 To 100
      Ee_fs_tageswerte(i) = Fs_tageswerte(i)
   Next I
   Ee_fs_speicherdatum_monate = Fs_speicherdatum_monate
   #if Debug_freesol
      Print "Speicherdatum Monate geschrieben: " ; Fs_speicherdatum_monate
   #endif
   Ee_fs_monatswerte = Fs_monatswerte
   Ee_fs_speicherdat_lfdmon = Fs_speicherdat_lfdmon
   Ee_fs_lfdmonwerte = Fs_lfdmonwerte
   #if Debug_freesol
      Print "Speicherdatum lfdMonat geschrieben: " ; Fs_speicherdat_lfdmon
   #endif

   Fs_pulszahlges = 0
   Ee_fs_pulszahlges = 0

   For I = 1 To 288
     Ee_fs_min_bezug(i) = 0
     Ee_fs_min_einspeis(i) = 0
   Next I

End Sub

'*******************************************************************************
'  Freesol-Werte im Eram mit dummy belegen
'*******************************************************************************
Sub Fs_eeram_dummy
Local I As Integer
Local Wsysday As Word
Local S As String * 9
Local J As Integer
   Wsysday = Sysday(netio_time)
   Fs_speicherdatum_tage = Sysday(netio_time)
   Fs_speicherdatum_tage = Fs_speicherdatum_tage - 1
   For I = 1 To 100
      Fs_tageswerte(i) = I
   Next I
   Wsysday = Sysday(netio_time)
   S = Date(wsysday)
   S = Left(s , 2)
   J = Val(s)
   Fs_speicherdatum_monate = Wsysday - J
   Fs_monatswerte = 0
   Fs_speicherdat_lfdmon = Sysday(netio_time)
   Fs_speicherdat_lfdmon = Fs_speicherdat_lfdmon - 1
   Fs_lfdmonwerte = 0

   Ee_fs_speicherdatum_tage = Fs_speicherdatum_tage
   #if Debug_freesol
   Print "Speicherdatum Tage geschrieben: " ; Fs_speicherdatum_tage
   #endif
   For I = 1 To 100
      Ee_fs_tageswerte(i) = Fs_tageswerte(i)
   Next I
   Ee_fs_speicherdatum_monate = Fs_speicherdatum_monate
   #if Debug_freesol
      Print "Speicherdatum Monate geschrieben: " ; Fs_speicherdatum_monate
   #endif
   Ee_fs_monatswerte = Fs_monatswerte
   Ee_fs_speicherdat_lfdmon = Fs_speicherdat_lfdmon
   Ee_fs_lfdmonwerte = Fs_lfdmonwerte
   #if Debug_freesol
      Print "Speicherdatum lfdMonat geschrieben: " ; Fs_speicherdat_lfdmon
   #endif

   Fs_pulszahlges = 0
   Ee_fs_pulszahlges = 0
End Sub

'*******************************************************************************
'  3-Segmentanzeige updaten (Spezielle Anzeige fr Verein in Erlangen)
'*******************************************************************************
Sub Fs_lcd_update_3seg
   Local Fs_lcd_aktleist As Single
   Local Fs_lcd_aktleist_int As Integer
   Local I As Integer
   Local B As Byte

   Fs_lcd_letzte_pulszahl = Fs_lcd_diese_pulszahl
   Fs_lcd_diese_pulszahl = Fs_pulszahl

   Fs_lcd_aktleist = Fs_lcd_diese_pulszahl - Fs_lcd_letzte_pulszahl
   Fs_lcd_aktleist = Fs_lcd_aktleist * 100
   Fs_lcd_aktleist = Fs_lcd_aktleist / Fs_pulsfaktor
   Fs_lcd_aktleist = Fs_lcd_aktleist * 60                   ' Hier steht jetzt in Fs_lcd_aktleist aktuelle Leistung in 10 Wh
   Fs_lcd_aktleist_int = Fs_lcd_aktleist


   If Fs_lcd_aktleist_int > 0 Then
      I = Fs_lcd_aktleist_int Mod 10
      B = I
 '  Elseif Fs_lcd_aktleist_int > 999 Then
 '     B = 128
   Else
      B = 10
   End If
   Fs_lcd_3seg_display 64 , B

   If Fs_lcd_aktleist_int > 9 Then
      Fs_lcd_aktleist_int = Fs_lcd_aktleist_int - I
      I = Fs_lcd_aktleist_int Mod 100
      I = I / 10
      B = I
'   Elseif Fs_lcd_aktleist_int > 999 Then
'      B = 128
   Else
      B = 10
   End If
   Fs_lcd_3seg_display 66 , B

   If Fs_lcd_aktleist_int > 99 Then
      I = I * 10
      Fs_lcd_aktleist_int = Fs_lcd_aktleist_int - I
      Fs_lcd_aktleist_int = Fs_lcd_aktleist_int / 100
      B = Fs_lcd_aktleist_int
'   Elseif Fs_lcd_aktleist_int > 9 Then
'      B = 128
   Else
      B = 10
   End If
   Fs_lcd_3seg_display 68 , B



End Sub

Sub Fs_lcd_3seg_display(adresse As Byte , Zahl As Byte)
   '10 er Ziffer: 64/65
   '100 er Ziffer: 66/67
   '1000 er Ziffer: 68/68
   'Local Lcd_i2c_write As Byte
   'Lcd_i2c_write = 64
   'Local Lcd_i2c_read As Byte
   'Lcd_i2c_read = 65
   Local Segmente As Byte

     I2cstart
     I2cwbyte Adresse
     I2cwbyte 0

     Select Case Zahl
         Case 0:
               Segmente = 119                               '&H3F
         Case 1:
                Segmente = 20                               '
         Case 2:
                Segmente = 179                              '&H5B
         Case 3:
                Segmente = 182                              '&H4F
         Case 4:
                Segmente = 212                              '&H66
         Case 5:
                Segmente = 230                              '&H6D
         Case 6:
                Segmente = 231                              ' &H7D
         Case 7:
                Segmente = 52                               '&H07
         Case 8:
                Segmente = 247                              '&H7F
         Case 9:
                Segmente = 246                              '&H67
         Case 10:
                Segmente = 0                                '&H67

     End Select

     I2cwbyte Segmente
     I2cstop
End Sub

Sub Fs_lcd_display
   Local Sing As Single
   Local L As Long
       Incr Fs_lcd_timer
       If Fs_lcd_timer > 16 Then
            Fs_lcd_timer = 0
       Elseif Fs_lcd_timer = 11 Then
            Cls
            Locate 1 , 1
            Sing = Fs_akt_leist * 1000
            L = Sing
            Fs_lcdstring = Str(l)
            If Sing < 10 Then
               Fs_lcdstring = " " + Fs_lcdstring
            End If
            If Sing < 100 Then
               Fs_lcdstring = " " + Fs_lcdstring
            End If
            If Sing < 1000 Then
               Fs_lcdstring = " " + Fs_lcdstring
            End If
            If Sing < 10000 Then
               Fs_lcdstring = " " + Fs_lcdstring
            End If
            Fs_lcdstring = "Aktuell: " + Fs_lcdstring + " W"
            Lcd Fs_lcdstring
            Locate 2 , 1
            If Fs_schaltsignal = 1 Then
               Fs_lcdstring = "Schaltsignal An"
            Else
               Fs_lcdstring = "Schaltsignal Aus"
            End If
            Lcd Fs_lcdstring
            Locate 3 , 1
            Fs_lcdstring = "Status: OK"
            If Fs_alarmmailflag = 0 Then
               Fs_lcdstring = "Alarmmail!"
            End If
            Lcd Fs_lcdstring
       Elseif Fs_lcd_timer = 6 Then
            Cls
            Locate 1 , 1
            Fs_lcdsing2 = Fs_pulszahl - Fs_stundenstart(1)
            Fs_lcdsing2 = Fs_lcdsing2 / 1000
            If Fs_pulsfaktor <> 1000 Then
               Fs_lcdsing2 = Fs_lcdsing2 * 1000
               Fs_lcdsing2 = Fs_lcdsing2 / Fs_pulsfaktor
            End If
            Fs_lcdstring = Fusing(fs_lcdsing2 , "###.##")
            If Fs_lcdsing2 < 10 Then
               Fs_lcdstring = "  " + Fs_lcdstring
            End If
            If Fs_lcdsing2 < 100 Then
               Fs_lcdstring = " " + Fs_lcdstring
            End If
            Fs_lcdstring = "Heute:" + Fs_lcdstring + "kWh"
            Lcd Fs_lcdstring
            Locate 2 , 1
            Fs_lcdsing = Fs_pulszahl - Fs_stundenstart(1)
            Fs_lcdsing = Fs_lcdsing / Fs_anlagenleistung
            If Fs_pulsfaktor <> 1000 Then
               Fs_lcdsing = Fs_lcdsing * 1000
               Fs_lcdsing = Fs_lcdsing / Fs_pulsfaktor
            End If
            Fs_lcdstring = Fusing(fs_lcdsing , "##.##")
            If Fs_lcdsing < 10 Then
              Fs_lcdstring = "   " + Fs_lcdstring
            End If
            If Fs_lcdsing < 100 Then
               Fs_lcdstring = "  " + Fs_lcdstring
            End If
            Fs_lcdstring = Fs_lcdstring + "kWh/kWp"
            Lcd Fs_lcdstring
            Locate 3 , 1
            Fs_lcdsing = Fs_lfdmonwerte
            Fs_lcdsing = Fs_lcdsing / 1000
            Fs_lcdsing = Fs_lcdsing + Fs_lcdsing2
            Fs_lcdstring = Fusing(fs_lcdsing , "####.#")
            If Fs_lcdsing < 10 Then
               Fs_lcdstring = "  " + Fs_lcdstring
            End If
            If Fs_lcdsing < 100 Then
               Fs_lcdstring = " " + Fs_lcdstring
            End If
            Fs_lcdstring = "Monat: " + Fs_lcdstring + "kWh"
            Lcd Fs_lcdstring
            Fs_lcdsing2 = Fs_anlagenleistung
            Fs_lcdsing2 = Fs_lcdsing2 / 1000
            Fs_lcdsing = Fs_lcdsing / Fs_lcdsing2
            Fs_lcdstring = Fusing(fs_lcdsing , "###.##")
            If Fs_lcdsing < 10 Then
              Fs_lcdstring = "   " + Fs_lcdstring
            End If
            If Fs_lcdsing < 100 Then
               Fs_lcdstring = "  " + Fs_lcdstring
            End If
            Fs_lcdstring = Fs_lcdstring + "kWh/kWp"
            Locate 4 , 1
            Lcd Fs_lcdstring
       Elseif Fs_lcd_timer = 1 Then
            Cls
            Locate 1 , 1
            Lcd "FreeSol Logger"
            Locate 2 , 1
            Lcd "Version " ; Fs_version
            Locate 3 , 1
            Lcd My_s12_hostname
            If Ntp_valid = 1 Then
               Locate 4 , 1
               Fs_lcdstring = Date$
               Fs_lcdstring = Left(fs_lcdstring , 6)
               Lcd Fs_lcdstring ; "  " ; Time(netio_time)
            End If
       End If

End Sub

Function Fs_sequenzsuchen(startpos As Integer) As Integer
' In fs_sml (Werte gespeichert ab Index 1) wird der Suchstring fs_smlsuch (Werte gespeichert ab Index 1) gesucht
' Letzter Wert von fs_sml liegt in fs_smlaz
' Letzter Wert von fs_smlsuch liegt in fs_smlsuchaz
' Zurckgegeben wird 0, falls nichts gefunden wird, und die Startposiiton der sequenz sonst
   Local Ssi As Integer
   Local Ssj As Integer
      Local Ssk As Integer
   Local Ssende As Integer
   Local Ssende2 As Integer
   Local Ssstimmt As Integer
   Local Ssstimmt2 As Integer

   Ssende = Fs_smlaz - Fs_smlsuchaz
   Ssende = Ssende + 1
 ' Print Startpos ; "  " ; fs_smlaz ; "  " ; fs_smlsuchaz ; "  " ; Ssende ; "  " ; Ssende2

      Ssstimmt = 0
      For Ssi = Startpos To Ssende
         Ssende2 = Ssi + Fs_smlsuchaz
         Ssende2 = Ssende2 - 1
         Ssstimmt2 = 1
'         Print Ssi ; "  " ; fs_smlaz ; "  " ; fs_smlsuchaz ; "  " ; Ssende ; "  " ; Ssende2
         For Ssj = Ssi To Ssende2
            Ssk = Ssj - Ssi
            Ssk = Ssk + 1
            If Fs_sml(ssj) <> Fs_smlsuch(ssk) Then
           ' Print Ssj ; "  " ; fs_sml(ssj) ; "  " ; fs_smlsuch(ssk)

                Ssstimmt2 = 0
                Ssj = Ssende2
            End If
         Next
         If Ssstimmt2 = 1 Then
            Ssstimmt = Ssi
            Ssi = Ssende
         End If
      Next


      Fs_sequenzsuchen = Ssstimmt

End Function

Sub Fs_smllesen
   Local S1 As String * 20
   Local S2 As String * 20
   Local I As Integer
   Local J As Integer
   Local Status As Integer
   Local Abbruch As Integer
   Local B As Byte
   Local Posstart As Integer                                ' Anfangsposition der Startsequenz (beginnt mit 1)
   Local Posende As Integer                                 ' Anfangsposition der Endsequenz (beginnt mit 1)
   Local Pos180 As Integer
   Local Pos280 As Integer
   Local Wert180 As Long
   Local Wert280 As Long
   Local Wert180d As Double
   Local Wert280d As Double
   Local Suchergebnis As Integer
   Local Erfolg As Integer

   S1 = Date(netio_time)
   S2 = Time(netio_time)
   Fs_smllesezeit = S1 + "  " + S2
   Fs_meldung = "Stat: "


   ' Auf Sendelcke warten
   I = 0
   Status = 0

   Do
      Clear Serialin
      Reset Watchdog
      Waitms 100
      If Ischarwaiting() = 1 Then
         I = I + 1
         Status = 1                                         ' Noch keine Sendelcke entdeckte
      Else
         I = 10                                             ' Sendelcke entdeckt
         Status = 2
      End If
   Loop Until I = 10

   S1 = Str(status)
   Fs_meldung = S1



   If Status = 2 Then
      ' Maximal 3 s auf erste Zeichen warten
      I = 0
      J = 0

      Do
        If Ischarwaiting() = 0 Then
           I = I + 1
           Reset Watchdog
           Waitms 10
           Status = 3                                       ' Noch kein Zeichen empfangen
        Else
           I = 300
           Status = 4                                       ' erstes Zeichen ist da
        End If
      Loop Until I = 300

      S1 = Str(status)
      Fs_meldung = Fs_meldung + "  " + S1


     'Auslesen bis 10 ms Lesepause
      Fs_smlaz = 0
      Abbruch = 0
      Do
         If Ischarwaiting() = 1 Then
            Incr Fs_smlaz
            B = Inkey()
            Fs_sml(fs_smlaz) = B
         Else
            Reset Watchdog
            Waitms 10
            If Ischarwaiting() = 0 Then
               Abbruch = 1
               Status = 5                                   ' Leseende wegen Meldungsende
            End If
         End If
         If Fs_smlaz >= 500 Then
            Abbruch = 1
            Status = 6                                      'Leseende wegen Zu langer Nachricht
         End If
      Loop Until Abbruch = 1
   End If

   S1 = Str(status)
   S2 = Str(fs_smlaz)
   Fs_meldung = Fs_meldung + "  " + S1
   Fs_meldung = Fs_meldung + "  Zeich: " + S2


   ' Prfen auf manuelle RS232-Eingabe: #50#
   'Fs_smlsuch(1) = 35
   'Fs_smlsuch(2) = 53
   'Fs_smlsuch(3) = 48
   'Fs_smlsuch(4) = 35
   'Erfolg = Fs_sequenzsuchen(1)

   'If Erfolg <> 0 Then
   '   Fs_rs232_hello
   'End If

   ' Prfen auf manuelle RS232-Eingabe: {50}
   'Fs_smlsuch(1) = 123
   'Fs_smlsuch(2) = 53
   'Fs_smlsuch(3) = 48
   'Fs_smlsuch(4) = 125
   'Erfolg = Fs_sequenzsuchen(1)

   'If Erfolg <> 0 Then
   '   Fs_rs232_status
   'End If



   ' Auswertung der SML-Nachricht
   Posstart = 0
   Posende = 0
   Pos180 = 0
   Pos280 = 0

   ' Suche Nachrichtenanfang
   Fs_smlsuch(1) = 27
   Fs_smlsuch(2) = 27
   Fs_smlsuch(3) = 27
   Fs_smlsuch(4) = 27
   Fs_smlsuch(5) = 1
   Fs_smlsuch(6) = 1
   Fs_smlsuch(7) = 1
   Fs_smlsuch(8) = 1
   Fs_smlsuchaz = 8
   Erfolg = Fs_sequenzsuchen(1)


   If Erfolg <> 0 Then
      Posstart = Erfolg
      Erfolg = 1
   End If


   ' Suche Nachrichtenende      (Hex 1B, 1B, 1B,1B, 1A)
   If Erfolg = 1 Then
      If Fs_smlaz > 4 Then
         Fs_smlsuch(1) = 27
         Fs_smlsuch(2) = 27
         Fs_smlsuch(3) = 27
         Fs_smlsuch(4) = 27
         Fs_smlsuch(5) = 26
         Fs_smlsuchaz = 5
         Suchergebnis = Fs_sequenzsuchen(1)
         If Suchergebnis <> 0 Then
            Posende = Suchergebnis
            Erfolg = 2
         End If
      End If
   End If


   ' Checksumme prfen
   I = Posende + 5
   Fs_crccalc = Crc_berechnen_libsml(posstart , I)
   I = Posende + 6
   B = Fs_sml(i)
   J = B
   I = Posende + 7
   B = Fs_sml(i)
   Fs_crcstore = J * 256
   Fs_crcstore = Fs_crcstore + B
   Fs_smllesezahl = Fs_smllesezahl + 1

   If Fs_crcstore <> Fs_crccalc Then
      Erfolg = 98
      Fs_crcfehlerzahl = Fs_crcfehlerzahl + 1
   End If

   ' Suche fs_Loggertyp
   If Erfolg = 2 Then
      Fs_loggertyp = ""

      ' Suche EMH eHz
      Fs_smlsuch(1) = &H77
      Fs_smlsuch(2) = &H7
      Fs_smlsuch(3) = &H81
      Fs_smlsuch(4) = &H81
      Fs_smlsuch(5) = &HC7
      Fs_smlsuch(6) = &H82
      Fs_smlsuch(7) = &H3
      Fs_smlsuch(8) = &HFF
      Fs_smlsuch(9) = &H1
      Fs_smlsuch(10) = &H1
      Fs_smlsuch(11) = &H1
      Fs_smlsuch(12) = &H1
      Fs_smlsuch(13) = &H4
      Fs_smlsuch(14) = &H45
      Fs_smlsuch(15) = &H4D
      Fs_smlsuch(16) = &H48
      Fs_smlsuch(17) = 1
      Fs_smlsuchaz = 17
      Suchergebnis = Fs_sequenzsuchen(1)
      If Suchergebnis <> 0 Then
         Fs_loggertyp = "EMH eHz"
         Erfolg = 3
      End If

      ' Suche Easymeter Q3C
      If Fs_loggertyp = "" Then
         Fs_smlsuch(1) = &H77
         Fs_smlsuch(2) = &H7
         Fs_smlsuch(3) = &H81
         Fs_smlsuch(4) = &H81
         Fs_smlsuch(5) = &HC7
         Fs_smlsuch(6) = &H82
         Fs_smlsuch(7) = &H3
         Fs_smlsuch(8) = &HFF
         Fs_smlsuch(9) = &H1
         Fs_smlsuch(10) = &H1
         Fs_smlsuch(11) = &H1
         Fs_smlsuch(12) = &H1
         Fs_smlsuch(13) = &H4
         Fs_smlsuch(14) = &H45
         Fs_smlsuch(15) = &H53
         Fs_smlsuch(16) = &H59
         Fs_smlsuch(17) = 1
         Fs_smlsuchaz = 17
         Suchergebnis = Fs_sequenzsuchen(1)
         If Suchergebnis <> 0 Then
            Fs_loggertyp = "Easymeter QC3"
            Erfolg = 3
         End If
      End If

         ' Suche Hager EHZ363Z5
      If Fs_loggertyp = "" Then
         Fs_smlsuch(1) = &H77
         Fs_smlsuch(2) = &H7
         Fs_smlsuch(3) = &H81
         Fs_smlsuch(4) = &H81
         Fs_smlsuch(5) = &HC7
         Fs_smlsuch(6) = &H82
         Fs_smlsuch(7) = &H3
         Fs_smlsuch(8) = &HFF
         Fs_smlsuch(9) = &H1
         Fs_smlsuch(10) = &H1
         Fs_smlsuch(11) = &H1
         Fs_smlsuch(12) = &H1
         Fs_smlsuch(13) = &H4
         Fs_smlsuch(14) = &H48
         Fs_smlsuch(15) = &H41
         Fs_smlsuch(16) = &H47
         Fs_smlsuch(17) = 1
         Fs_smlsuchaz = 17
         Suchergebnis = Fs_sequenzsuchen(1)
         If Suchergebnis <> 0 Then
            Fs_loggertyp = "Hager EHZ363Z5"
            Erfolg = 3
         End If
      End If



   End If


   ' EMH Auswertung:
   If Fs_loggertyp = "EMH eHz" Then
      ' Suche 1.8.0         (Hex 77,7,1,0,1,8)
      If Erfolg = 3 Then
         S1 = Str(erfolg)
         Fs_meldung = Fs_meldung + " E " + S1

         Fs_smlsuch(1) = 119
         Fs_smlsuch(2) = 7
         Fs_smlsuch(3) = 1
         Fs_smlsuch(4) = 0
         Fs_smlsuch(5) = 1
         Fs_smlsuch(6) = 8
         Fs_smlsuchaz = 6
         Suchergebnis = Fs_sequenzsuchen(1)
         If Suchergebnis <> 0 Then
            Pos180 = Suchergebnis
            Erfolg = 4
            J = Fs_sml(pos180 + 8)
            If J = 98 Then
               Fs_loggertyp = "EMH eHz Typ 1"
            Elseif J = 99 Then
               Fs_loggertyp = "EMH eHz Typ 2"
               Pos180 = Pos180 + 1
            Elseif J = 100 Then
               Fs_loggertyp = "EMH eHz Typ 3"
               Pos180 = Pos180 + 2
            Else
               Erfolg = 99                                  'abbruch
               J = 0
            End If
            J = Fs_sml(pos180 + 17)
            Wert180 = J

            Wert180 = Wert180 * 256
            J = Fs_sml(pos180 + 18)
            Wert180 = Wert180 + J

            Wert180 = Wert180 * 256
            J = Fs_sml(pos180 + 19)
            Wert180 = Wert180 + J

            Wert180 = Wert180 * 256
            J = Fs_sml(pos180 + 20)
            Wert180 = Wert180 + J

            Wert180d = Wert180
            Wert180d = Wert180d / 10000
         End If
      End If


      ' Suche 2.8.0         (Hex 77,7,1,0,2,8)
      If Erfolg > 2 Then 'Es wird auch der Fall mit abgedeckt, dass kein Bezug gefunden wurde
         S1 = Str(erfolg)
         Fs_meldung = Fs_meldung + " " + S1

         Fs_smlsuch(1) = 119
         Fs_smlsuch(2) = 7
         Fs_smlsuch(3) = 1
         Fs_smlsuch(4) = 0
         Fs_smlsuch(5) = 2
         Fs_smlsuch(6) = 8
         Fs_smlsuchaz = 6
         Suchergebnis = Fs_sequenzsuchen(1)
         If Suchergebnis <> 0 Then
            Pos280 = Suchergebnis
            Erfolg = 5
            J = Fs_sml(pos280 + 8)
            If J = 98 Then
               Fs_loggertyp = "EMH eHz Typ 1"
            Elseif J = 99 Then
               Fs_loggertyp = "EMH eHz Typ 2"
               Pos280 = Pos280 + 1
            Elseif J = 100 Then
               Fs_loggertyp = "EMH eHz Typ 3"
               Pos280 = Pos280 + 2
            Else
               Erfolg = 99                                  'abbruch
               J = 0
            End If
            J = Fs_sml(pos280 + 17)
            Wert280 = J

            Wert280 = Wert280 * 256
            J = Fs_sml(pos280 + 18)
            Wert280 = Wert280 + J

            Wert280 = Wert280 * 256
            J = Fs_sml(pos280 + 19)
            Wert280 = Wert280 + J

            Wert280 = Wert280 * 256
            J = Fs_sml(pos280 + 20)
            Wert280 = Wert280 + J

            Wert280d = Wert280
            Wert280d = Wert280d / 10000
            Fs_bezug = Wert180d
            Fs_einspeis = Wert280d
            Wert180d = Wert180d * 1000
            Wert280d = Wert280d * 1000

            ' 1min SML Werte eintragen
            Fs_bezug_l_alt1 = Fs_bezug_l
            Fs_einspeis_l_alt1 = Fs_einspeis_l

            Fs_bezug_l = Wert180d
            Fs_einspeis_l = Wert280d
            S1 = Str(fs_smlaz)
            Fs_meldung = "Zeich: " + S1 + " Zhler: " + Fs_loggertyp
         End If
      End If
   Elseif Fs_loggertyp = "Easymeter QC3" Then
   ' Suche 1.8.0
      If Erfolg = 3 Then
         Fs_smlsuch(1) = &H77
         Fs_smlsuch(2) = 7
         Fs_smlsuch(3) = 1
         Fs_smlsuch(4) = 1
         Fs_smlsuch(5) = 1
         Fs_smlsuch(6) = 8
         Fs_smlsuch(7) = 0
         Fs_smlsuchaz = 7
         Suchergebnis = Fs_sequenzsuchen(1)
         If Suchergebnis <> 0 Then
            Pos180 = Suchergebnis
            Erfolg = 4
            J = Fs_sml(pos180 + 27)
            Wert180 = J

            Wert180 = Wert180 * 256
            J = Fs_sml(pos180 + 28)
            Wert180 = Wert180 + J

            Wert180 = Wert180 * 256
            J = Fs_sml(pos180 + 29)
            Wert180 = Wert180 + J

            Wert180 = Wert180 * 256
            J = Fs_sml(pos180 + 30)
            Wert180 = Wert180 + J

            Wert180d = Wert180
            Wert180d = Wert180d * 256
            ' Letztes Byte wird igrnoriert

            Wert180d = Wert180d / 10000000
         End If
      End If


      ' Suche 2.8.0
      If Erfolg = 4 Then
         Fs_smlsuch(1) = &H77
         Fs_smlsuch(2) = 7
         Fs_smlsuch(3) = 1
         Fs_smlsuch(4) = 1
         Fs_smlsuch(5) = 1
         Fs_smlsuch(6) = 8
         Fs_smlsuch(7) = 1
         Fs_smlsuchaz = 7
         Suchergebnis = Fs_sequenzsuchen(1)
         If Suchergebnis <> 0 Then
            Pos280 = Suchergebnis
            Erfolg = 5
            J = Fs_sml(pos280 + 25)
            Wert280 = J

            Wert280 = Wert280 * 256
            J = Fs_sml(pos280 + 26)
            Wert280 = Wert280 + J

            Wert280 = Wert280 * 256
            J = Fs_sml(pos280 + 27)
            Wert280 = Wert280 + J

            Wert280d = Wert280
            Wert280d = Wert280d / 100
            Fs_bezug = Wert180d
            Fs_einspeis = Wert280d
            Wert180d = Wert180d * 1000
            Wert280d = Wert280d * 1000

            ' 1min SML Werte eintragen
            Fs_bezug_l_alt1 = Fs_bezug_l
            Fs_einspeis_l_alt1 = Fs_einspeis_l


            Fs_bezug_l = Wert180d
            Fs_einspeis_l = Wert280d
            S1 = Str(fs_smlaz)
            Fs_meldung = "Zeich: " + S1 + " Zhler: " + Fs_loggertyp
          End If
      End If

   Elseif Fs_loggertyp = "Hager EHZ363Z5" Then
   ' Suche 1.8.0
      If Erfolg = 3 Then
         Fs_smlsuch(1) = &H77
         Fs_smlsuch(2) = 7
         Fs_smlsuch(3) = 1
         Fs_smlsuch(4) = 0
         Fs_smlsuch(5) = 1
         Fs_smlsuch(6) = 8
         Fs_smlsuchaz = 6
         Suchergebnis = Fs_sequenzsuchen(1)
         If Suchergebnis <> 0 Then
            Pos180 = Suchergebnis
            Erfolg = 4
            J = Fs_sml(pos180 + 16)                         'Alt:27
            Wert180 = J

            Wert180 = Wert180 * 256
            J = Fs_sml(pos180 + 17)
            Wert180 = Wert180 + J

            Wert180 = Wert180 * 256
            J = Fs_sml(pos180 + 18)
            Wert180 = Wert180 + J

            J = Fs_sml(pos180 + 15)

            If J = 85 Then                                  ' Markerbyte H55: 4 Stellen, H54: 3 Stellen
               Wert180 = Wert180 * 256
               J = Fs_sml(pos180 + 19)
               Wert180 = Wert180 + J
            End If

            Wert180d = Wert180

            Wert180d = Wert180d / 10000
         End If
      End If


      ' Suche 2.8.0
      If Erfolg = 4 Then
         Fs_smlsuch(1) = &H77
         Fs_smlsuch(2) = 7
         Fs_smlsuch(3) = 1
         Fs_smlsuch(4) = 0
         Fs_smlsuch(5) = 2
         Fs_smlsuch(6) = 8
         Fs_smlsuchaz = 6
         Suchergebnis = Fs_sequenzsuchen(1)
         If Suchergebnis <> 0 Then
            Pos280 = Suchergebnis
            Erfolg = 5
            J = Fs_sml(pos280 + 16)
            Wert280 = J

            Wert280 = Wert280 * 256
            J = Fs_sml(pos280 + 17)
            Wert280 = Wert280 + J

            Wert280 = Wert280 * 256
            J = Fs_sml(pos280 + 18)
            Wert280 = Wert280 + J

            J = Fs_sml(pos280 + 15)
            If J = 85 Then                                  ' Markerbyte H55: 4 Stellen, H54: 3 Stellen
               Wert280 = Wert280 * 256
               J = Fs_sml(pos280 + 19)
               Wert280 = Wert280 + J
            End If

            Wert280d = Wert280
            Wert280d = Wert280d / 10000
            Fs_bezug = Wert180d
            Fs_einspeis = Wert280d
            Wert180d = Wert180d * 1000
            Wert280d = Wert280d * 1000

            ' 1min SML Werte eintragen
            Fs_bezug_l_alt1 = Fs_bezug_l
            Fs_einspeis_l_alt1 = Fs_einspeis_l


            Fs_bezug_l = Wert180d
            Fs_einspeis_l = Wert280d
            S1 = Str(fs_smlaz)
            Fs_meldung = "Zeich: " + S1 + " Zhler: " + Fs_loggertyp
          End If
      End If

   End If
End Sub


Function Crc_berechnen_libsml(byval Startp As Integer , Byval Endp As Integer) As Word

        Local Fcs As Word

        Local I As Integer
        Local J As Integer
        Local K As Integer

        Fcs = &HFFFF

        For J = Startp To Endp
            I = Fcs Xor Fs_sml(j)
            I = I And &HFF
            K = Lookup(i , Fcstab)
             Shift Fcs , Right , 8
            Fcs = Fcs Xor K
        Next J
        Fcs = Fcs Xor &HFFFF
        K = Fcs And &HFF
        Shift K , Left , 8
        Fcs = Fcs And &HFF00
        Shift Fcs , Right , 8
        Fcs = K Or Fcs

        Crc_berechnen_libsml = Fcs
End Function


'Sub Fs_rs232_hello
'     Print "Hello World Freesol: "

'End Sub

'Sub Fs_rs232_status
'   Local S As String * 50
'   Local I As Integer
'   Local Sing As Single


'                             Print
'                              Print "Version: " ; Fs_version
'                              Print "Datum: " ; Date$
'                              Print "Zeit: " ; Time$
'                              Print "NTP-Status: " ;
'                              If Ntp_valid = 1 Then
'                                 Print "aktualisiert"
'                              Else
'                                 Print "nicht aktualisiert"
'                              End If
'                            '  Print "{50}" ; Str(my_b_ipaddr_l)
'                              Print "{50}" ; Str(my_b_ipaddr(1)) ; "." ; Str(my_b_ipaddr(2)) ; "." ; Str(my_b_ipaddr(3)) ; "." ; Str(my_b_ipaddr(4))
' '                             Print "{51}" ; Str(my_b_subnetmask_l)
'                              Print "{51}" ; Str(my_b_subnetmask(1)) ; "." ; Str(my_b_subnetmask(2)) ; "." ; Str(my_b_subnetmask(3)) ; "." ; Str(my_b_subnetmask(4))
'                              Print "{52}" ; Hex(my_b_macaddr(1)) ; ":" ; Hex(my_b_macaddr(2)) ; ":" ; Hex(my_b_macaddr(3)) ; ":" ; Hex(my_b_macaddr(4)) ; ":" ; Hex(my_b_macaddr(5)) ; ":" ; Hex(my_b_macaddr(6))
'                              Print "{53}" ; My_s12_hostname
                              Print "{54}" ; Str(my_b_defaultgateway_l)
'                              Print "{54}" ; Str(my_b_defaultgateway(1)) ; "." ; Str(my_b_defaultgateway(2)) ; "." ; Str(my_b_defaultgateway(3)) ; "." ; Str(my_b_defaultgateway(4))
'                             #if Include_dns = 1
'                             ' Print "{55}" ; Str(dns_b_nameserver_l)
'                              Print "{55}" ; Str(dns_b_nameserver(1)) ; "." ; Str(dns_b_nameserver(2)) ; "." ; Str(dns_b_nameserver(3)) ; "." ; Str(dns_b_nameserver(4))
'                             #endif
'                             #if Include_ntp > 0
                              Print "{56}" ; Str(ntp_b_server_l)
'                              Print "{56}" ; Str(ntp_b_server(1)) ; "." ; Str(ntp_b_server(2)) ; "." ; Str(ntp_b_server(3)) ; "." ; Str(ntp_b_server(4))
'                             #endif
'                             #if Include_ntp = 0
'                              Print "{56}-100"
'                             #endif
'                             #if Include_php_call
'                              Print "{57}" ; Str(my_netio_addr)
'                              Print "{58}" ; Str(my_php_server_ip_addr_l)       'Str(my_php_server_ip_addr(1)) ; "." ; Str(my_php_server_ip_addr(2)) ; "." ; Str(my_php_server_ip_addr(3)) ; "." ; Str(my_php_server_ip_addr(4))
'                              Print "{59}" ; My_php_script
'                              Print "{60}" ; Php_base_second
'                             #endif
'                             #if Netio_mode = 90
'                              Smtp_s31_meine_email_adresse = Ee_s31_meine_email_adresse
'                              S = Left(smtp_s31_meine_email_adresse , 18)
'                              Print "{71}" ; S
'                              S = Mid(smtp_s31_meine_email_adresse , 19 , 13)
'                              Print "{72}" ; S

'                              Smtp_s31_empfaenger_mail_adresse = Ee_s31_empfaenger_email_adresse
'                              S = Left(smtp_s31_empfaenger_mail_adresse , 18)
'                              Print "{73}" ; S
'                              S = Mid(smtp_s31_empfaenger_mail_adresse , 19 , 13)
'                              Print "{74}" ; S

'                              Smtp_s47_benutzerkennung = Ee_s47_benutzerkennung       '47
'                              I = Len(smtp_s47_benutzerkennung)
'                              I = I - 2
'                              S = Left(smtp_s47_benutzerkennung , I)
'                              Print "{75}" ; S
'                              Smtp_s31_passwort = Ee_s31_passwort
'                              I = Len(smtp_s31_passwort)
'                              I = I - 2
'                              S = Left(smtp_s31_passwort , I)
'                              Print "{76}" ; S
'                              Fs_anlagenleistung = Ee_fs_anlagenleistung
'                              Print "{77}" ; Fs_anlagenleistung
'                              Fs_pulszahlges = Ee_fs_pulszahlges
'                              Print "{78}" ; Fs_pulszahlges
'                              Fs_pulsfaktor = Ee_fs_pulsfaktor
'                              Print "{81}" ; Fs_pulsfaktor
'                              Fs_lcd = Ee_fs_lcd
'                              Print "{82}" ; Fs_lcd
'                              Print "Fs_startzeit_ntp: " ; Fs_startzeit_ntp
'                              Print "Fs_startzeit_offset: " ; Fs_startzeit_offset
'                             #endif

'End Sub